// file: $ISIP_SNR/util/snr_calculator/v1.0/snrc_comp_3.cc
//
// finds the pdf of the data
//

// isip include files
//
#include <integral.h>
#include <integral_constants.h>

// local include files
//
#include "snr_calculator.h"

#include "snr_calculator_constants.h"

// function: compute_pdf_cc
//
// arguments:
//
//  float_4** data: (input) sampled data [num_values_a x num_channels_a]
//  int_4** pdf: (output) the pdf for each channel of data
//  float_4** mean_vals: (output) mean values of each bin in the pdf
//  float_4* max: (input) max values
//  float_4* min: (input) min values
//  int_4 num_values: (input) number of values in the data array
//  int_4 num_chans: (input) number of samples in the data stream
//  
// return value: a logical_1 indicating status
//
// this finds the probability distribution function of the data
// note: the mean_vals are assumed to be initialized to zero
//
logical_1 compute_pdf_cc(float_4** data_a, int_4** pdf_a,
			 float_4** mean_vals_a, float_4* max_a,
			 float_4* min_a, int_4 num_values_a,
			 int_4 num_channels_a) {

  // make sure that the pdf and mean values are allocated
  //
  if ((pdf_a == (int_4**)NULL) || (mean_vals_a == (float_4**)NULL)) {

    // return with error
    //
    return ISIP_FALSE;
  }

  // initialize all of the pdf bins
  //
  for (int_4 chan = 0; chan < num_channels_a; chan++) {

    for (int_4 bin = 0; bin < SNRC_NUM_BINS; bin++) {
      pdf_a[bin][chan] = (int_4)0;
    }
  }

  // loop over all channels
  //
  for (int_4 chan = 0; chan < num_channels_a; chan++) {

    // determine the spacing for each bin of the pdf
    //
    float_4 pdf_bin_width = (max_a[chan] - min_a[chan]) /
      (float_4)SNRC_NUM_BINS;
    
    // loop over all data
    //
    for (int_4 samp_num = (int_4)0; samp_num < num_values_a; samp_num++) {

      // see if it is equivalent to the maximum value. if so, it goes in the
      // last bin
      //
      if (data_a[samp_num][chan] == max_a[chan]) {

	(pdf_a[SNRC_NUM_BINS - 1][chan])++;
	mean_vals_a[SNRC_NUM_BINS -1][chan] += data_a[samp_num][chan];
      }
      else {

	int_4 bin_num = (int_4)((data_a[samp_num][chan] - min_a[chan]) /
				pdf_bin_width);
	(pdf_a[bin_num][chan])++;
	mean_vals_a[bin_num][chan] += data_a[samp_num][chan];
      }
    }
  }

  // now loop over all channels and bins and find the mean value
  //
  for (int_4 chan = 0; chan < num_channels_a; chan++) {
    for (int_4 bin_num = 0; bin_num < SNRC_NUM_BINS; bin_num++) {

      if (pdf_a[bin_num][chan] == (float_4)0.0) {
	mean_vals_a[bin_num][chan] =  (((max_a[chan] - min_a[chan]) /
	  (float_4)SNRC_NUM_BINS) * ((float_4)2 * (float_4)bin_num +
				     (float_4)1) / (float_4)2) +
	  min_a[chan];
      }
      else {
	mean_vals_a[bin_num][chan] /= pdf_a[bin_num][chan];
      }
    }
  }
  // exit gracefully
  //
  return ISIP_TRUE;
}
