// file: $ISIP_SNR/util/snr_calculator/v1.0/snrc_comp_2.cc
//
// computes the energy for each channel of a signal
//

// isip include files
//
#include <integral.h>
#include <integral_constants.h>

// local include files
//
#include "snr_calculator.h"

#include "snr_calculator_constants.h"

// function: compute_energy_cc
//
// arguments:
//
//  float_4* data: (input) sampled data
//  int_4 num_samples: (input) number of samples in the data stream
//  int_4 num_channels: (input) number of channels in the data stream
//  float_4* energy_values: (output) the energy for each channel of this data
//  
// return value: a logical_1 indicating status
//
// this function computes the average energy of the windowed data according
// to the algorithm:
//
//   sum over i=0,...,num_samples_a { [data(i) * data(i)] / num_samples}
//
logical_1 compute_energy_cc(float_4* data_a, int_4 num_samples_a,
			    int_4 num_channels_a, float_4* energy_values_a) {

  // make sure that the energy data is allocated
  //
  if (energy_values_a == (float_4*)NULL) {

    // return with error
    //
    return ISIP_FALSE;
  }
  
  // loop over all channels
  //
  for (int_4 chan = 0; chan < num_channels_a; chan++) {

    float_4 energy = (float_4)0.0;
    
    // loop over all data
    //
    for (int_4 samp_num = 0; samp_num < num_samples_a; samp_num++) {

      // store the current sample
      //
      float_4 x_n = data_a[samp_num * num_channels_a + chan];

      // increment the total energy by the e(i)
      //
      energy += x_n * x_n;
    }

    // normalize the energy
    //
    energy /= (float_4)num_samples_a;

    // store the energy value in the appropriate channel slot
    //
    energy_values_a[chan] = energy;
  }

  // exit gracefully
  //
  return ISIP_TRUE;
}

