// file: $ISIP_SNR/util/snr_calculator/v1.0/snrc_comp_0.cc
//
// preemphasizes the data using a standard pre-emphasis filter
//

// isip include files
//
#include <integral.h>
#include <integral_constants.h>

// local include files
//
#include "snr_calculator.h"

#include "snr_calculator_constants.h"

// function: pre_emphasize_data_cc
//
// arguments:
//
//  float_4* data: (input/output) sampled data
//  int_4 num_samples: (input) number of samples in the data stream
//  int_4 num_channels: (input) number of channels in the data stream
//  
// return value: a logical_1 indicating status
//
// this function pre-emphasizes the input data using the filter:
//
//   1 - (a * z^(-1)).
//
// the input data is overwritten
//
logical_1 pre_emphasize_data_cc(float_4* data_a, int_4 num_samples_a,
				int_4 num_channels_a) {

  // loop over all channels
  //
  for (int_4 chan = 0; chan < num_channels_a; chan++) {

    // create x(n-1) for the pre-emphasis filter and x(n)
    //
    float_4 xn_minus = (float_4)0.0;
    float_4 xn = (float_4)0.0;
    
    // loop over all data
    //
    for (int_4 samp_num = 0; samp_num < num_samples_a; samp_num++) {

      // store x(n)
      //
      xn = data_a[samp_num * num_channels_a + chan];

      // compute and store the pre-emphasized x(n) value
      //
      data_a[samp_num * num_channels_a + chan] = xn - (SNRC_PRE_EMPH_COEFF *
						       xn_minus);
      
      // shift the data to the left
      //
      xn_minus = xn;
    }
  }

  // exit gracefully
  //
  return ISIP_TRUE;
}

