// file: $ISIP_SNR/util/snr_calculator/v1.0/snr_calculator_constants.h
//

// Make sure this file is only included once
//
#ifndef __ISIP_SNR_CALCULATOR_CONSTANTS
#define __ISIP_SNR_CALCULATOR_CONSTANTS

// isip include files
//
#ifndef __ISIP_INTEGRAL_CONSTANTS
#include <integral_constants.h>
#endif

#ifndef __ISIP_SIGNAL_CONSTANTS
#include <signal_constants.h>
#endif

// define the help file
//
#define SNRC_HELP_FILE "$ISIP_SNR/util/snr_calculator/v1.0/snr_calculator.help"

// define the command-line parameter flags
//
#define SNRC_OPT_HELP (char_1*)"-help"
#define SNRC_OPT_FILE_IN (char_1*)"-input"
#define SNRC_OPT_DEBUG_MODE (char_1*)"-debug"
#define SNRC_OPT_USE_HAMMING (char_1*)"-use_hamming"
#define SNRC_OPT_PRE_EMPH (char_1*)"-use_pre_emph"
#define SNRC_OPT_SIG_THRESH (char_1*)"-sig_thresh"
#define SNRC_OPT_NOISE_THRESH (char_1*)"-noise_thresh"
#define SNRC_OPT_FRAME_DUR (char_1*)"-frame_dur"
#define SNRC_OPT_WINDOW_DUR (char_1*)"-window_dur"
#define SNRC_OPT_SF (char_1*)"-sf"
#define SNRC_OPT_NUM_CHANS (char_1*)"-num_chans"
#define SNRC_OPT_SWAP (char_1*)"-swap_bytes"

// define the default parameter values
//
#define SNRC_DEF_USE_HAMMING ISIP_FALSE
#define SNRC_DEF_PRE_EMPH ISIP_FALSE
#define SNRC_DEF_SIG_THRESH (float_4)0.8500
#define SNRC_DEF_NOISE_THRESH (float_4)0.1500
#define SNRC_DEF_FRAME_DUR (float_4)10.0
#define SNRC_DEF_WINDOW_DUR (float_4)20.0
#define SNRC_DEF_SF (float_4)8000.0
#define SNRC_DEF_NUM_CHANS (int_4)1
#define SNRC_DEF_SWAP (logical_1)ISIP_FALSE

// define the number of bytes per sample per channel in the file
//
#define SNRC_NUM_BYTES (int_4)2

// define a conversion from milliseconds to seconds
//
#define SNRC_MSEC_TO_SEC (float_4)0.001

// define the pre-emphasis coefficient and scale factor
//
#define SNRC_PRE_EMPH_COEFF (float_4)0.95

// define the coefficient for the hamming window
//
#define SNRC_HAMMING_COEFF (float_4)0.54

// define the number of bins to use for the probability distributions
//
#define SNRC_NUM_BINS (int_4)10000

// end of file
//
#endif
