// file: $ISIP_SNR/util/snr_calculator/v1.0/snr_calculator.h
//

// Make sure this file is only included once
//
#ifndef __ISIP_SNR_CALCULATOR
#define __ISIP_SNR_CALCULATOR

// isip include files
//
#ifndef __ISIP_INTEGRAL
#include <integral.h>
#endif

#include <signal.h>

// function prototypes
//
// function to get the command line parameters
//
logical_1 get_parameter_cc(int argc, char** argv, logical_1& use_hamming,
			   logical_1& apply_pre_emphasis,
			   float_4& signal_thresh, float_4& noise_thresh,
			   float_4& frame_dur, float_4& window_dur,
			   float_4& sample_freq, int_4& num_chans,
			   logical_1& swap_byte,
			   char_1* input_file, int_4& debug_mode);

// function to pre-emphasize the data
//
logical_1 pre_emphasize_data_cc(float_4* data, int_4 num_samples,
				int_4 num_channels);

// function to apply a hamming window to the data
//
logical_1 window_hamming_cc(float_4* data, int_4 num_samples,
			    int_4 num_channels);

// function to calculate the energy of a frame of data
//
logical_1 compute_energy_cc(float_4* data, int_4 num_samples,
			    int_4 num_channels, float_4* energy_values);

// function to find the maximum and minimum of a distribution
//
logical_1 find_max_min_cc(float_4** data, float_4* max, float_4* min,
			  int_4 num_values, int_4 num_channels);

// function to calculate the pdf of data
//
logical_1 compute_pdf_cc(float_4** data, int_4** pdf, float_4** mean_vals,
			 float_4* max, float_4* min, int_4 num_values,
			 int_4 num_channels);

// function to calculate the probabilistic snr of the data 
//
logical_1 compute_snr_cc(int_4** cdf, float_4 signal_thresh,
			 float_4 noise_thresh, int_4 num_values,
			 int_4 num_channels, float_4* max,
			 float_4* min, float_4** mean_vals,
			 float_4* snr_values);

logical_1 do_this(Signal& signal);

// end of file
//
#endif


