# file: $isip/util/misc/make/compile_and_link.make

# this makefile contains a standard set of dependencies and targets
# that are used by all makefiles in the environment.
#

#------------------------------------------------------------------------------
#
# define variables section
#
#------------------------------------------------------------------------------

# create filenames
#
SRCS = $(wildcard $(ISIP_FILES))
OBJS = $(subst .cc,.o,$(SRCS))
BEXE = $(subst .exe,$(ISIP_INSTALL_EXT),$(ISIP_EXE))

# define flags for the C++ and C compilers
#
I_FLAGS      = $(ISIP_IFLAGS)
CPLUS_FLAGS  = -Wall $(ISIP_CFLAGS) -c
C_FLAGS      =
LD_FLAGS     = $(ISIP_CFLAGS)

# define dependencies: note that we include, by default, a makefile
#  located in the current directory, so that changes to the makefile
#  will trigger a make. note also the dependency on isip libraries
#
ALL_DEPS = $(ISIP_DEPS)

# define libraries
#
ALL_LIBS = $(ISIP_LFLAGS_BEFORE) $(ISIP_LFLAGS_AFTER)

# define suffixes
#
.SUFFIXES: .cc

# make sure we clean up
#  note: this code is executed ALL the time
#
.DONE:

# make everything silent
#
#.SILENT:

#------------------------------------------------------------------------------
#
# define targets and dependencies
#
#------------------------------------------------------------------------------

# define executable dependencies
#
$(ISIP_EXE): $(OBJS)
	echo "> linking $(ISIP_EXE)"
	$(ISIP_CPLUS_COMPILER) $(LD_FLAGS) -o $(ISIP_EXE) $(OBJS) $(ALL_LIBS)

# include file dependencies (define only the significant relationships)
#
$(OBJS): $(ALL_DEPS)

# define source file dependencies
#
.cc.o:
	echo "> compiling " $< "with flags" $(ISIP_CFLAGS)
	$(ISIP_CPLUS_COMPILER) $(I_FLAGS) $(CPLUS_FLAGS) $(C_FLAGS) $<

# define a link-only target
#
link: $(OBJS)
	echo "> linking $(ISIP_EXE)"
	$(ISIP_CPLUS_COMPILER) $(LD_FLAGS) -o $(ISIP_EXE) $(OBJS) $(ALL_LIBS)

# install
#
install: $(ISIP_EXE)
	echo "> installing binary" $(ISIP_BIN)/$(BEXE)
	cp $(ISIP_EXE) $(ISIP_BIN)/$(BEXE)

# clean up (the -rm lets make continue after errors)
#
clean:
	-echo "> removing objects and binary" $(ISIP_EXE)
	-rm $(ISIP_EXE)
	-echo "> removing" $(OBJS)
	-rm $(OBJS)

# check existence
#
check: $(SRCS)

#
# end of file
