// file: $ECE_8993/class/signal/v1.0/signal_constants.h
//
// this file defines global paths, filenames and constants of the signal class
//

// make sure definitions are made only once
//
#ifndef __ISIP_SIGNAL_CONSTANTS
#define __ISIP_SIGNAL_CONSTANTS

// isip include files
//
#ifndef __ISIP_INTEGRAL_CONSTANTS
#include <integral_constants.h>
#endif

// define the class name
//
#define SIGNAL_CLASS_NAME (char_1*)"Signal"

// define the default values for signal parameters
//
#define SIGNAL_DEFAULT_NUM_CHANS (int_4)1
#define SIGNAL_DEFAULT_NUM_BYTES (int_4)2
#define SIGNAL_DEFAULT_SF (float_4)8000.0
#define SIGNAL_DEFAULT_SWAP_BYTES ISIP_FALSE

// define the characters used to trigger filename expansion
// via a system call - since this is expensive, we only want to do
// it when it is absolutely necessary
//
#define SIGNAL_ENV_DELIMITERS "$~(){}[]?"

// end of file
//
#endif
