// file: $isip/class/math/integral/integral_constants.h
//
// definitions of standard constants used throughout the isip environment.
//

// make sure definitions are only made once
//
#ifndef __ISIP_INTEGRAL_CONSTANTS
#define __ISIP_INTEGRAL_CONSTANTS

// system include file
//
#include <limits.h>
#include <math.h>

// isip include files
//
#ifndef __ISIP_INTEGRAL
#include <integral.h>
#endif

//-----------------------------------------------------------------------------
//
// general constants
//
//-----------------------------------------------------------------------------

// define a symbol to identify the environment
//
#define ISIP_ENV_NAME "isip"

// define standard return values for programs and methods
//
#define ISIP_NO_ERROR (int)0
#define ISIP_ERROR (int)1

// define logical true and false
//
#define ISIP_FALSE (logical)0
#define ISIP_TRUE (logical)1

// define some maximum sizes (i/o in unix still needs some fixed
// buffers every now and then)
//
#define ISIP_MAX_FNAME_SIZE PATH_MAX
#define ISIP_MAX_STRING_LENGTH 1024

// define some constants related to geometry and pi
//
#define ISIP_TWOPI (double)(2.0*M_PI)
#define ISIP_SQRT_TWOPI (double)2.506628274631
#define ISIP_INV_SQRT_TWOPI (double)0.3989422804014327
#define ISIP_DEGREES_IN_CIRCLE (double)360.0

// define a default value to seed random number generators
// of course, we use 27 because this is joe picone's favorite number
//
#define ISIP_RANDSEED 27

// define important powers of two
// these must be hardcoded to prevent unpredictable arithmetic overflows
//
#define ISIP_2EXP7 128.0
#define ISIP_2EXP8 256.0
#define ISIP_2EXP15 32768.0
#define ISIP_2EXP16 65536.0
#define ISIP_2EXP23 8388608.0
#define ISIP_2EXP24 16777216.0
#define ISIP_2EXP31 2147483648.0
#define ISIP_2EXP32 4294967296.0

// define the number of bits per byte
//
#define ISIP_NUMBER_BITS_PER_BYTE (long)8
#define ISIP_NUMBER_BYTES_PER_KBYTE (long)1024

// define the smallest floating point value
//
#define ISIP_MINIMUM_FLOAT_4 FLT_MIN

// define dB constants
//
#define ISIP_DB_POW_MIN_VALUE (double)1.0e-10
#define ISIP_DB_POW_SCALE_FACTOR (double)10.0

#define ISIP_DB_MAG_MIN_VALUE (double)1.0e-10
#define ISIP_DB_MAG_SCALE_FACTOR (double)20.0

#define ISIP_DB_MIN_VALUE (double)-100.0

// define some important character constants
//
#define ISIP_NEWLINE '\n'
#define ISIP_TAB '\t'
#define ISIP_NULL '\0'
#define ISIP_SPACE ' '
#define ISIP_SLASH '/'
#define ISIP_BACKSLASH '\\'
#define ISIP_PERIOD '.'
#define ISIP_DOLLAR '$'
#define ISIP_TILDE '~'
#define ISIP_UNDERSCORE '_'
#define ISIP_POUND '#'

#define ISIP_STRING_SPACE " "
#define ISIP_STRING_SLASH "/"
#define ISIP_STRING_BACKSLASH "\\"
#define ISIP_STRING_PERIOD "."
#define ISIP_STRING_DOLLAR "$"
#define ISIP_STRING_TILDE "~"
#define ISIP_STRING_UNDERSCORE "_"

#define ISIP_UNIX_CMD_COPY "cp"
#define ISIP_UNIX_CMD_MOVE "mv"
#define ISIP_UNIX_CMD_REDIR "2>&1"

// define some important sizes
//
#define ISIP_SIZEOF_INT_3 (long)3
#define ISIP_SIZEOF_UINT_3 (long)3

// define some sorting constants - it is useful from time to time to have
// a global notion of the result of the order of things. these constants
// should be used for sorting classes, comparisons, etc.
//
#define ISIP_ORDER_ASCENDING (long)0
#define ISIP_ORDER_DESCENDING (long)1
#define ISIP_ORDER_COLLATING (long)2

// define some comparison constants - it is useful from time to time to have
// a global notion of the result of a comparison. these constants should be
// used for sorting classes, comparisons, etc. negative values are not used
// so that the return codes are compatible with the error code ISIP_ERROR.
// 
#define ISIP_COMPARE_LESSER (long)0
#define ISIP_COMPARE_EQUAL (long)1
#define ISIP_COMPARE_GREATER (long)2

// define some debugging constants
//
#define ISIP_DEBUG_NONE (long)0
#define ISIP_DEBUG_BRIEF (long)1
#define ISIP_DEBUG_DETAILED (long)2
#define ISIP_DEBUG_FULL (long)3

// define some constants related to help generation
//
#define ISIP_HELP_FORMAT (unichar*)"more %s"
#define ISIP_HELP_OPTION (unichar*)"-help"

//-----------------------------------------------------------------------------
//
// define some constants related to file i/o - these are defined here
// because they are constants that most programs should use
//
//-----------------------------------------------------------------------------

// i/o modes
//
#define ISIP_UNKNOWN (long)-1

#define ISIP_READ_ONLY (long)0
#define ISIP_READ_PLUS (long)1
#define ISIP_WRITE_ONLY (long)2
#define ISIP_WRITE_PLUS (long)3

#define ISIP_ASCII (long)0
#define ISIP_BINARY (long)1

// define default object tag values:
//  these tag indices are used to signal a main program that either:
//   (1) the first instance of an object is to be processed
//   (2) all instances of an object are to be processed
//  all other tag indices are considered to be >= 0.
//
#define ISIP_TAG_NOT_FOUND (long)-1
#define ISIP_PROCESS_FIRST (long)-2
#define ISIP_PROCESS_ALL (long)-3

// define a location of temporary files
//
#define ISIP_TMPDIR "/tmp"

// end of file
//
#endif
