// file: $ECE_8993/class/signal/v1.0/signal.h
//	

// make sure definitions are made only once
//
#ifndef __ISIP_SIGNAL
#define __ISIP_SIGNAL

// isip include files
//
#ifndef __ISIP_INTEGRAL
#include <integral.h>
#endif

#ifndef __ISIP_SIGNAL_CONSTANTS
#include "signal_constants.h"
#endif

// Signal : a class meant to handle the a raw signal file
//
class Signal {

  //---------------------------------------------------------------------------
  //
  // protected members
  //
  //---------------------------------------------------------------------------
protected:

  // filename information
  //
  char_1* fname_d;
  FILE* fp_d;                        // file pointer

  // information about the signal
  //
  int_4 num_chans_d;                 // number of channels in the file
  int_4 num_bytes_d;                 // number of bytes per sample per channel
  float_4 sf_d;                      // sample frequency of the data
  logical_1 swap_byte_flag_d;        // type of byte swapping
  float_4 end_file_time_d;           // end time of the file
  int_4 file_size_d;		     // number of samples in file

  // debug level
  //
  int_4 debug_level_d;
  
  //---------------------------------------------------------------------------
  //
  // public methods
  //
  //---------------------------------------------------------------------------
public:

  // required methods
  //
  char_1* name_cc();
  volatile void error_handler_cc(char_1* method_name, char_1* message);
  logical_1 debug_cc(FILE* fp, char_1* message);
  logical_1 set_debug_cc(int_4 level);  

  // destructor/constructor
  //
  ~Signal();
  Signal();

  // file methods
  //
  logical_1 expand_cc(char_1* o_name, char_1* i_name);
  logical_1 open_cc(char_1* filename, int_4 mode);
  logical_1 close_cc();
  
  // read methods
  //
  logical_1 read_cc(float_4*& data, float_4 start_time, float_4 end_time,
		    int_4& num_samples);
  logical_1 read_cc(float_4*& data, int_4 start_samp, int_4 end_samp,
		    int_4& num_samples);

  // write methods
  //
  logical_1 write_cc(float_4* data, float_4 start_time, int_4 end_time);
  logical_1 write_cc(float_4* data, int_4 start_samp, int_4 end_time);  

  // assignment methods
  //
  logical_1 set_filename_cc(char_1* filename);
  logical_1 set_num_chans_cc(int_4 num_chans);
  logical_1 set_num_bytes_cc(int_4 num_bytes);
  logical_1 set_sample_frequency_cc(float_4 sf);
  logical_1 set_swap_byte_flag_cc(logical_1 swap_byte_flag);
  logical_1 set_cc(char_1* filename, int_4 num_chans, int_4 num_bytes,
		   float_4 sf, logical_1 swap_byte_flag);
  
  // get methods
  //
  logical_1 get_filename_cc(char_1* filename);
  int_4 get_num_chans_cc();
  int_4 get_num_bytes_cc();
  float_4 get_sample_frequency_cc();
  logical_1 get_swap_byte_flag_cc();
  logical_1 get_cc(char_1* filename, int_4& num_chans, int_4& num_bytes,
		   float_4& sf, logical_1& swap_byte_flag);
  float_4 get_end_file_time_cc();
  int_4 get_file_size_cc();    
  
  //---------------------------------------------------------------------------
  //
  // private methods
  //
  //---------------------------------------------------------------------------
private:

};

// end of file
//
#endif
