// file: $ECE_8993/class/signal/v1.0/sig_set_5.cc
//
 
// isip include files
//
#include "signal.h"
 
#include <integral_constants.h>
#include "signal_constants.h"
 
// method: set_cc
//
// arguments:
//   char_1* filename: (input) name of the signal file
//   int_4 num_chans: (input) number of channels in the signal file
//   int_4 num_bytes: (input) number of bytes per sample per channel
//                            of the signal file
//   float_4 sf: (input) sample frequency of the signal
//   logical_1 swap_byte_flag: (input) whether or not to swap flags
//
// return: none
//
// this method assigns sets the class data
//
logical_1 Signal::set_cc(char_1* filename_a, int_4 num_chans_a,
			 int_4 num_bytes_a, float_4 sf_a,
			 logical_1 swap_byte_flag_a) {

  // define a flag to indicate the status of the assignments
  //
  logical_1 status_flag = ISIP_TRUE;
  
  // set the filename
  //
  if (set_filename_cc(filename_a) == ISIP_FALSE) {

    // set the flag to false
    //
    status_flag = ISIP_FALSE;
  }

  // set the number of channels
  //
  if (set_num_chans_cc(num_chans_a) == ISIP_FALSE) {

    // set the flag to false
    //
    status_flag = ISIP_FALSE;
  }

  // set the number of bytes per sample per channel
  //
  if (set_num_bytes_cc(num_bytes_a) == ISIP_FALSE) {

    // set the flag to false
    //
    status_flag = ISIP_FALSE;
  }

  // set the sample frequency
  //
  if (set_sample_frequency_cc(sf_a) == ISIP_FALSE) {

    // set the flag to false
    //
    status_flag = ISIP_FALSE;
  }

  // set the byte swapping mode
  //
  if (set_swap_byte_flag_cc(swap_byte_flag_a) == ISIP_FALSE) {

    // set the flag to false
    //
    status_flag = ISIP_FALSE;
  }
  
  // exit gracefully
  //
  return status_flag;
}
