// file: $ECE_8993/class/signal/v1.0/sig_set_0.cc
//
 
// isip include files
//
#include "signal.h"
 
#include <integral_constants.h>
#include "signal_constants.h"
 
// method: set_filename_cc
//
// arguments:
//  char_1* filename: (input) filename of the signal file
//
// return: none
//
// this method assigns the filename for the signal file
//
logical_1 Signal::set_filename_cc(char_1* filename_a) {

  // delete the current filename
  //
  if (fname_d != (char_1*)NULL) {
    delete [] fname_d;
    fname_d = (char_1*)NULL;
  }

  // make sure the input filename is valid
  //
  if (filename_a == (char_1*)NULL) {
    error_handler_cc((char_1*)"set_filename_cc",
		     (char_1*)"input filename is invalid");
    return ISIP_FALSE;
  }

  // determine the size of the input filename and allocate that much memory
  //
  fname_d = new char_1[strlen((char*)filename_a) + 1];
  
  // copy the filename
  //
  strcpy((char*)fname_d, (char*)filename_a);

  // exit gracefully
  //
  return ISIP_TRUE;
}
