// file: $ECE_8993/class/signal/v1.0/sig_open_0.cc
//

// system include files
//
#include <string.h>

// isip include files
//
#include "signal.h"
#include <integral_constants.h>

// method: open_cc
//
// arguments: 
//  char_1* filename : (input) signal file to be opened
//  int_4 mode : (input) the desired access mode
//
// return: none
//     
// this method opens the signal file in the given mode and exits
//

logical_1 Signal::open_cc(char_1* filename_a, int_4 mode_a) {
  
  // check if there is already an open pointer
  //
  if (fp_d != (FILE*)NULL) {
    error_handler_cc((char_1*)"open_cc",
		     (char_1*)"file has not been closed");
  }

  // expand the filename
  //
  char_1 expand_name[ISIP_MAX_FNAME_SIZE];

  if (expand_cc(expand_name, filename_a) == ISIP_FALSE) {
    error_handler_cc((char_1*)"open_cc", (char_1*)"error expanding name");
  }
  
  // mode: readonly
  //
  if (mode_a  == ISIP_READ_ONLY) {
    fp_d = fopen((char*)expand_name, "r");
  }
  
  // mode: write only
  //
  else if (mode_a  == ISIP_WRITE_ONLY) {
    fp_d = fopen((char*)expand_name, "w");
  }
    
  // check if there is an error in opening this file
  //
  if (fp_d == (FILE*)NULL) {
    error_handler_cc((char_1*)"open_cc",
		     (char_1*)"cannot open file");
  }
    
  // save the filename
  //
  if (fname_d != (char_1*)NULL) {
    delete [] fname_d;
    fname_d = (char_1*)NULL;
  }
    
  fname_d = new char_1[ISIP_MAX_FNAME_SIZE];
  memset(fname_d,(int)0, ISIP_MAX_FNAME_SIZE);
  strcpy((char*)fname_d, (char*)expand_name);
    
  // if we are reading this file, then determine the end time of the file
  //
  if (mode_a == ISIP_READ_ONLY) {

    // compute the end of file
    //
    fseek(fp_d, 0, SEEK_END);
    file_size_d = (int_4)ftell(fp_d);

    // determine the time that this corresponds to
    //
    end_file_time_d = (float_4)file_size_d / 
      (sf_d * (float_4)num_bytes_d * (float_4)num_chans_d);
  }
  
  // exit gracefully
  //
  return ISIP_TRUE;
}




