// file: $ECE_8993/class/signal/v1.0/sig_get_5.cc
//

// isip include files
//
#include "signal.h"

#include <integral_constants.h>
#include "signal_constants.h"

// method: get_cc
//
// arguments:
//   char_1* filename: (output) name of the signal file
//   int_4& num_chans: (output) number of channels in the signal file
//   int_4& num_bytes: (output) number of bytes per sample per channel
//                            of the signal file
//   float_4& sf: (output) sample frequency of the signal
//   logical_1& swap_byte_flag: (output) whether or not to swap flags
//
// return: logical_1 indicating status
//
logical_1 Signal::get_cc(char_1* filename_a, int_4& num_chans_a,
			 int_4& num_bytes_a, float_4& sf_a,
			 logical_1& swap_byte_flag_a) {

  // define a flag to indicate the status of the assignments
  //
  logical_1 status_flag = ISIP_TRUE;
  
  // get the filename
  //
  if (get_filename_cc(filename_a) == ISIP_FALSE) {

    // set the flag to false
    //
    status_flag = ISIP_FALSE;
  }

  // get the number of channels
  //
  num_chans_a = get_num_chans_cc();

  // get the number of bytes per sample per channel
  //
  num_bytes_a = get_num_bytes_cc();

  // get the sample frequency
  //
  sf_a = get_sample_frequency_cc();

  // get the byte swapping mode
  //
  swap_byte_flag_a = get_swap_byte_flag_cc();
  
  // exit gracefully
  //
  return status_flag;
}





