// file: $ECE_8993/class/signal/v1.0/sig_get_0.cc
//

// isip include files
//
#include "signal.h"

#include <integral_constants.h>
#include "signal_constants.h"

// method: get_filename_cc
//
// arguments:
//   char_1*& filename: (output) filename to set (memory should be defined
//                      externally)
//
// return: a logical_1 indicating status
//
logical_1 Signal::get_filename_cc(char_1* filename_a) {

  // make sure that memory is allocated for the class data and for the output
  // filename
  //
  if ((fname_d == (char_1*)NULL) || (filename_a == (char_1*)NULL)) {

    // call the error handler
    //
    error_handler_cc((char_1*)"get_filename_cc",
		     (char_1*)"memory not allocated for filenames");
  }

  // copy the filenames
  //
  strcpy((char*)filename_a, (char*)fname_d);

  // exit gracefully
  //
  return ISIP_TRUE;
}




