// file: $ECE_8993/class/signal/v1.0/sig_exp_0.cc
//

// system include files
//
#include <string.h>

// isip include files
//
#include "signal.h"
#include "signal_constants.h"

#include <integral_constants.h>

// method: expand_cc
//
// arguments:
//  char_1* o_name: (output) name with all environmental symbols
//			     and variables expanded
//  char_1* i_name: (input) name needing expansion
//
// return: a logical_1 value indicating status
//
// this method replaces all environment variables and other such
// things in a string with their equivalent expansions. for example:
// 
//  $HOME/foo.text		=> /u1/person/foo.text
//  foo.text/$HOME/data		=> foo.text//u1/person/data
//
// in other words, variables or aliases anywhere in the string
// will be replaced.
//
// this method now uses popen/pclose rather than complicated
// function calls and string replacements.
//
logical_1 Signal::expand_cc(char_1* o_name_a, char_1* i_name_a) {

  // scan the incoming string for special characters
  //
  int_4 len = strlen((char*)i_name_a);
  logical_1 flag_match = ISIP_FALSE;
  
  for (int_4 i = 0; i < len; i++) {
    if (strchr(SIGNAL_ENV_DELIMITERS, i_name_a[i]) != (char*)NULL) {
      flag_match = ISIP_TRUE;
      break;
    }
  }

  // if necessary, expand the string
  //
  if (flag_match == ISIP_TRUE) {

    // build a Unix command
    //
    char_1 buf[ISIP_MAX_FNAME_SIZE];
    sprintf((char*)buf, "echo %s\n", (char*)i_name_a);

    // execute the pipe
    //
    FILE* fp = popen((char*)buf, "r");
    fgets((char*)o_name_a, ISIP_MAX_FNAME_SIZE, fp);
    pclose(fp);

    // strip the trailing linefeed
    //
    len = strlen((char*)o_name_a) - (int_4)1;
    o_name_a[len] = ISIP_NULL;

    // make sure everything got expanded
    //
    flag_match = ISIP_FALSE;
    for (int_4 i=0; i<len; i++) {
      if (strchr(SIGNAL_ENV_DELIMITERS, o_name_a[i]) != (char*)NULL) {
	return ISIP_FALSE;
      }
    }
  }

  // else, just copy the string
  //
  else {
    strcpy((char*)o_name_a, (char*)i_name_a);
  }

  // exit gracefully
  //
  return ISIP_TRUE;

}





