// file: $ECE_8993/class/signal/v1.0/sig_err_0.cc
//

// isip include files
//
#include "signal.h"

#include <integral_constants.h>
#include "signal_constants.h"

// method: error_handler_cc
//
// arguments:
//  char_1* mname: (input) method name in which the error occurred
//  char_1* msg: (input) message to be printed
//
// return: none
//
// this method displays an error message.
//
volatile void Signal::error_handler_cc(char_1* mname_a, char_1* msg_a) {

  // display a message
  //
  if (mname_a != (char_1*)NULL) {

    // check for no message
    //
    if (msg_a != (char_1*)NULL) {
      fprintf(stdout, "%s::%s: %s\n", SIGNAL_CLASS_NAME, mname_a, msg_a);
    }
    else {
      fprintf(stdout, "%s::%s: fatal error\n", SIGNAL_CLASS_NAME, mname_a);
    }
  }
}


