# file: lib/Link.pm
#

# this file contains the data structure and subroutines for generating
# confusion network generation and consensus hypothesis. Note that all
# functions in this package return 0 if there is an error and 1
# otherwise. This is chosen to coincide with the notion of true and
# false. Note that this is different than the return values for system
# calls where 1 is an error and 0 is no error
#

# package name and system libraries
#
package Link;
use Class::Struct;

#----------------------------------------------------------------------------
#
# data structures
#
#----------------------------------------------------------------------------

struct Link => {
    word => '$',
    start_time => '$',
    end_time => '$',
    prob => '$',
};

# return 1 to make perl happy
#
return 1;

#
# end of file
