#!/bin/bash

# file: $NEDC_NFC/bin/nedc_eeg_score
#
# revision history:
#
# 20221216 (ML): initial version
#
# A simple script that scores how well the model performed
#

# set important environment variables
#
. nedc_eeg_resnet_env

# set the output directory
#
TRAIN_OUT_DIR="$OUTPUT_DIR/train/report"
DEV_OUT_DIR="$OUTPUT_DIR/dev/report"
EVAL_OUT_DIR="$OUTPUT_DIR/eval/report"

# set the directory leading to the decoded csvbi files
#
TRAIN_DECODE_OUT_DIR="$OUTPUT_DIR/train"
DEV_DECODE_OUT_DIR="$OUTPUT_DIR/dev"
EVAL_DECODE_OUT_DIR="$OUTPUT_DIR/eval"

# create the final nedc_eval_eeg output directories
#
mkdir -p $TRAIN_OUT_DIR
mkdir -p $DEV_OUT_DIR
mkdir -p $EVAL_OUT_DIR

# set the ref list files
#
TRAIN_REF_FILE="$TRAIN_OUT_DIR/ref.list"
DEV_REF_FILE="$DEV_OUT_DIR/ref.list"
EVAL_REF_FILE="$EVAL_OUT_DIR/ref.list"

# create the ref list files
#
cp $TRAIN_CSVBI_LIST $TRAIN_REF_FILE
cp $DEV_CSVBI_LIST $DEV_REF_FILE
cp $EVAL_CSVBI_LIST $EVAL_REF_FILE

# set the hyp list files
#
TRAIN_HYP_FILE="$TRAIN_OUT_DIR/hyp.list"
DEV_HYP_FILE="$DEV_OUT_DIR/hyp.list"
EVAL_HYP_FILE="$EVAL_OUT_DIR/hyp.list"

# fill the hyp list file with csv_bi files from decoding in sorted order
#
find $TRAIN_DECODE_OUT_DIR -name "*.csv_bi" | sort > $TRAIN_HYP_FILE
find $DEV_DECODE_OUT_DIR -name "*.csv_bi" | sort > $DEV_HYP_FILE
find $EVAL_DECODE_OUT_DIR -name "*.csv_bi" | sort > $EVAL_HYP_FILE

# set the parameter file
#
PARAM="$LIB_DIR/nedc_eval_eeg_params_v00.txt"

# set the command line arguments
#
TRAIN_CMD_ARG="-p $PARAM -o $TRAIN_OUT_DIR $TRAIN_REF_FILE $TRAIN_HYP_FILE"
DEV_CMD_ARG="-p $PARAM -o $DEV_OUT_DIR $DEV_REF_FILE $DEV_HYP_FILE"
EVAL_CMD_ARG="-p $PARAM -o $EVAL_OUT_DIR $EVAL_REF_FILE $EVAL_HYP_FILE"

# set the python script
#
DRIVER_SCRIPT="$TOOL_DIR/nedc_eval_eeg/src/nedc_eval_eeg.py"

# set the final command
#
TRAIN_CMD="python $DRIVER_SCRIPT $TRAIN_CMD_ARG"
DEV_CMD="python $DRIVER_SCRIPT $DEV_CMD_ARG"
EVAL_CMD="python $DRIVER_SCRIPT $EVAL_CMD_ARG"

# run scoring on the train dataset
#
echo "==== Scoring the Train Dataset ===="
echo "Scoring the Train Dataset Started on: $(date "+%D %T")"
$TRAIN_CMD
echo "Scoring the Train Dataset Finished on: $(date "+%D %T")"

# run scoring on the dev dataset
#
echo "==== Scoring the Dev Dataset ===="
echo "Scoring the Dev Dataset Started on: $(date "+%D %T")"
$DEV_CMD
echo "Scoring the Dev Dataset Finished on: $(date "+%D %T")"

# run scoring on the eval dataset
#
echo "==== Scoring the Eval Dataset ===="
echo "Scoring the Eval Dataset Started on: $(date "+%D %T")"
$EVAL_CMD
echo "Scoring the Eval Dataset Finished on: $(date "+%D %T")"

#
# end of file
