#!/bin/bash

# file: $NEDC_NFC/bin/nedc_eeg_resnet_train
#
# revision history:
#
# 20221216 (ML): initial version
#
# A simple script that trains a model
#

# set important environment variables
#
. nedc_eeg_resnet_env

# set the parameter file
#
PARAM="$LIB_DIR/nedc_eeg_resnet_train_param.txt"

# set the command line arguments
#
CMD_ARG="-p $PARAM -t $TRAIN_EDF_LIST -c $TRAIN_CSVBI_LIST -e $DEV_EDF_LIST -d $DEV_CSVBI_LIST $MODEL_FILE"

# set the driver script
#
CMD_FILE="$TOOL_DIR/nedc_eeg_resnet_train/nedc_eeg_resnet_train.py"

# set the final command
#
CMD="python $CMD_FILE $CMD_ARG"

# run the final command
#
echo "==== Training the Model ===="
echo "Training Started on: $(date "+%D %T")"
$CMD
echo "Training Finished on: $(date "+%D %T")"
#
# end of file
