#!/bin/bash

# file: $NEDC_NFC/bin/nedc_eeg_resnet_env
#
# revision history:
#
# 20221216 (ML): initial version
#
# A simple script that sets the environment variable
#

# set an appropriate environment variable for the root node
#
NEDC_NFC=$(realpath $(pwd)/..);
export NEDC_NFC;

# add this tool to the Python library path
#
export PYTHONPATH=$PYTHONPATH:$NEDC_NFC/lib;

# Set up the directory heirarchy of the environment
#
ROOT_DIR="$NEDC_NFC"
LIB_DIR="$ROOT_DIR/lib"
TOOL_DIR="$ROOT_DIR/src/python/util"
LIST_DIR="$ROOT_DIR/test/list"
OUTPUT_DIR="$ROOT_DIR/test/output"
MODEL_DIR="$ROOT_DIR/models"

# defining locations of all needed files
#
TRAIN_EDF_LIST="$LIST_DIR/train_edf.list"
TRAIN_CSVBI_LIST="$LIST_DIR/train_csv.list"
DEV_EDF_LIST="$LIST_DIR/dev_edf.list"
DEV_CSVBI_LIST="$LIST_DIR/dev_csv.list"
EVAL_EDF_LIST="$LIST_DIR/eval_edf.list"
EVAL_CSVBI_LIST="$LIST_DIR/eval_csv.list"

# define model filenames
#
export MODEL_FILE="$MODEL_DIR/model.pckl"

# sort the edf and csv_bi list files
#
if test -f $TRAIN_EDF_LIST; then
    sort $TRAIN_EDF_LIST -o $TRAIN_EDF_LIST
fi
if test -f $TRAIN_CSVBI_LIST; then
    sort $TRAIN_CSVBI_LIST -o $TRAIN_CSVBI_LIST
fi
if test -f $DEV_EDF_LIST; then
    sort $DEV_EDF_LIST -o $DEV_EDF_LIST
fi
if test -f $DEV_CSVBI_LIST; then
    sort $DEV_CSVBI_LIST -o $DEV_CSVBI_LIST
fi
if test -f $EVAL_EDF_LIST; then
    sort $EVAL_EDF_LIST -o $EVAL_EDF_LIST
fi
if test -f $EVAL_CSVBI_LIST; then
    sort $EVAL_CSVBI_LIST -o $EVAL_CSVBI_LIST
fi

#
# end of file
