#!/bin/bash

# file: $NEDC_NFC/bin/scripts/nedc_eeg_resnet_decode
#
# revision history:
#
# 20221216 (ML): initial version
#
# A simple script that decodes the dataset using the trained model
#

# set important environment variables
#
. nedc_eeg_resnet_env

# defining the output directories
#
TRAIN_ODIR="$OUTPUT_DIR/train"
DEV_ODIR="$OUTPUT_DIR/dev"
EVAL_ODIR="$OUTPUT_DIR/eval"

# define the replace directory
#
RDIR="$NEDC_NFC/test/data"

# set the parameter file
#
PARAM="$LIB_DIR/nedc_eeg_resnet_decode_param.txt"

# set the command line arguments
#
TRAIN_CMD_ARG="-p $PARAM -o $TRAIN_ODIR -m $MODEL_FILE -r $RDIR $TRAIN_EDF_LIST"
DEV_CMD_ARG="-p $PARAM -o $DEV_ODIR -m $MODEL_FILE -r $RDIR $DEV_EDF_LIST"
EVAL_CMD_ARG="-p $PARAM -o $EVAL_ODIR -m $MODEL_FILE -r $RDIR $EVAL_EDF_LIST"

# set the driver script
#
CMD_FILE="$TOOL_DIR/nedc_eeg_resnet_decode/nedc_eeg_resnet_decode.py"

# set the final command
#
TRAIN_CMD="python $CMD_FILE $TRAIN_CMD_ARG"
DEV_CMD="python $CMD_FILE $DEV_CMD_ARG"
EVAL_CMD="python $CMD_FILE $EVAL_CMD_ARG"

# decode the training dataset
#
echo "==== Decoding the Train Dataset ===="
echo "Decoding the Train Dataset Started on: $(date "+%D %T")"
$TRAIN_CMD
echo "Decoding the Train Dataset Finished on: $(date "+%D %T")"

# decode the dev dataset
#
echo "==== Decoding the Dev Dataset ===="
echo "Decoding the Dev Dataset Started on: $(date "+%D %T")"
$DEV_CMD
echo "Decoding the Dev Dataset Finished on: $(date "+%D %T")"

# decode the eval dataset
#
echo "==== Decoding the Eval Dataset ===="
echo "Decoding the Eval Dataset Started on: $(date "+%D %T")"
$EVAL_CMD
echo "Decoding the Eval Dataset Finished on: $(date "+%D %T")"

#
# end of file
