#!/bin/bash

# file: $NEDC_NFC/src/shell/util/nedc_eeg_resnet_decode_realtime/nedc_*_env.sh
#
# revision history:
#
# 20230422 (JP): cosmetic changes
# 20230228 (ML): initial version
#
# A simple script that sets the environment variables for this system
#

# set an appropriate environment variable for the root node
#
NEDC_NFC=$(realpath $(pwd)/..);
export NEDC_NFC;

# add this tool to the Python library path
#
export PYTHONPATH=$PYTHONPATH:$NEDC_NFC/lib;

# Set up the directory heirarchy of the environment
#
ROOT_DIR="$NEDC_NFC"
LIB_DIR="$ROOT_DIR/lib"
TOOL_DIR="$ROOT_DIR/src/python/util"
TEST_DIR="$ROOT_DIR/test"
OUTPUT_DIR="$TEST_DIR/output"
MODEL_DIR="$ROOT_DIR/models"

# defining locations of all needed files
#
INPUT_FILE="None"
BASENAME="nedc_000"
PARAMS_DECODE="$LIB_DIR/params_v01.txt"

# define model filenames
#
RDIR="None"

#
# end of file
