#!/bin/bash

# file: $NEDC_NFC/src/shell/util/nedc_eeg_resnet_decode_realtime/nedc_*.sh
#
# revision history:
#
# 20230433 (JP): modified the interfaces
# 20230228 (ML): initial version
#
# A simple script that runs this entire system
#

# set important environment variables
#
. nedc_eeg_resnet_realtime_decode_env

# display a start of processing message
#
echo "Decoding Started on: $(date "+%D %T")"

# There are two ways to run the decoder: (1) from a file, or (2) from a stream.
# The data is written to the output directory. Typically a csv file is written
# with the annotation, and a binary file is written with the signal data.
#

# (1) Decode from a file: INPUT_FILE, the last argument, is the file
#     to be processed.
#

# (2) decode from a stream: To decode from a stream set the INPUT_FILE variable
#     as 'none' in nedc_eeg_resnet_realtime_decode_env. The edf signal needs
#     to be delivered to stdin a second's worth of data at a time a channel at a
#     time:
#
#      ...
#      x[0][0] x[1][0] x[2][0] ... x[N][0]
#      x[0][1] x[1][1] x[2][1] ... x[N][1]
#
#    where N is the samples per second (sample frequency), and x[2][1] denotes
#    the third sample in time for channel no. 2. The data are 16-bit binary
#    integers in the range [-32767, 32767].
#
"streaming data on stdin (optional)" | \
    $TOOL_DIR/nedc_driver/nedc_driver.py -p $PARAMS_DECODE -o $OUTPUT_DIR \
					 -r $RDIR -b $BASENAME $INPUT_FILE

# display an end of processing message
#
echo "Decoding Finished on: $(date "+%D %T")"

#
# end of file

