from pyqtgraph.Qt import QtWidgets

from .pref_tabs.demo_pref_tab_annotations import DemoPrefTabAnnotations
from .pref_tabs.demo_pref_tab_filters import DemoPrefTabFilters
from .pref_tabs.demo_pref_tab_general import DemoPrefTabGeneral
from .pref_tabs.demo_pref_tab_spectrogram import DemoPrefTabSpectrogram
from .pref_tabs.demo_pref_tab_energy import DemoPrefTabEnergy

from .demo_error_dialog import DemoErrorMessageDialog

#------------------------------------------------------------------------------
#
# classes are listed here
#
#------------------------------------------------------------------------------

class DemoPreferencesWidget(QtWidgets.QDialog):
    """
    Class: DemoPreferencesWidget

    arguments:
     none

    description:
     This class serves as the main QDialog for preferences functionality.
     It holds all the prefernces_tabs/ as well as the preferences buttons.
    """

    def __init__(self,
                 dict_lut_widget_a,
                 dict_main_window_a,
                 dict_spectrogram_a,
                 dict_filters_default_a,
                 dict_detrender_a,
                 dict_rhythms_a,
                 dict_roi_a,
                 dict_waveform_a,
                 dict_energy_a,
                 dict_order_a):
        """
        method: constructor

        arguments:
         - dict_*: these dictionaries are passed in from DemoPreferences and
                    will be immediately passed to their respective tabs

        returns:
         none

        description:
         this method initializes DemoPreferencesWidget, as well as calls
         other init methods
        """

        super(DemoPreferencesWidget, self).__init__()

        self.dict_lut_widget = dict_lut_widget_a

        self.dict_main_window = dict_main_window_a

        self.dict_spectrogram = dict_spectrogram_a

        self.dict_filters_default = dict_filters_default_a

        self.dict_detrender = dict_detrender_a

        self.dict_rhythms = dict_rhythms_a

        self.dict_roi = dict_roi_a

        self.dict_waveform = dict_waveform_a

        self.dict_energy = dict_energy_a

        self.dict_order = dict_order_a

        self.init_top_level()

        self.init_tabs()

        self.tab_widget.setCurrentIndex(0)

        self.error_dialog = DemoErrorMessageDialog()
    #
    # end of method

    def init_top_level(self):
        """
        method: init_top_level

        arguments:
         none

        returns:
         none

        description:
         this method creates a QGridLayout used to store the tabs and buttons,
         also creates buttons
        """

        self.setWindowTitle("Preferences")

        self.top_level_layout = QtWidgets.QGridLayout(self)
        self.tab_widget = QtWidgets.QTabWidget(self)
        self.tab_widget.setTabShape(QtWidgets.QTabWidget.Rounded)
        self.top_level_layout.addWidget(self.tab_widget, 1, 1, 1, 5)

        self.ok_button = QtWidgets.QPushButton("OK", self)
        self.top_level_layout.addWidget(self.ok_button, 2, 5, 1, 1)

        self.apply_button = QtWidgets.QPushButton("Apply", self)
        self.top_level_layout.addWidget(self.apply_button, 2, 1, 1, 1)

        self.cancel_button = QtWidgets.QPushButton("Cancel", self)
        self.top_level_layout.addWidget(self.cancel_button, 2, 4, 1, 1)

        self.save_button = QtWidgets.QPushButton("Save", self)
        self.top_level_layout.addWidget(self.save_button, 2, 2, 1, 1)
    #
    # end of method

    def init_tabs(self):
        """
        method: init_tabs

        arguments:
         none

        returns:
         none

        description:
         this method initializes all tabs and adds them to the QGridLayout
        """

        self.tab_general = DemoPrefTabGeneral(self.dict_main_window,
                                              self.dict_order,
                                              self.dict_waveform)
        self.tab_widget.addTab(self.tab_general, "General")

        self.tab_filters = DemoPrefTabFilters(self.dict_filters_default,
                                              self.dict_detrender,
                                              self.dict_rhythms)

        self.tab_widget.addTab(self.tab_filters, "Filters")

        self.tab_annotations = DemoPrefTabAnnotations(self.dict_roi)
        self.tab_widget.addTab(self.tab_annotations, "Annotations")

        self.tab_spectrogram = DemoPrefTabSpectrogram(self.dict_lut_widget,
                                                      self.dict_spectrogram)
        self.tab_widget.addTab(self.tab_spectrogram, "Spectrogram")

        self.tab_energy = DemoPrefTabEnergy(self.dict_energy)
        self.tab_widget.addTab(self.tab_energy, "Energy")

        #self.tab_montage = DemoPrefTabMontage()
        #self.tab_widget.addTab(self.tab_montage, "Montage")
    #
    # end of method

    def show_window(self):
        self.show()
        self.activateWindow()
        self.raise_()

