from pyqtgraph.Qt import QtWidgets

# strings that will be shown on the QMessageBox
#
# TODO: update for window size param change
message_spectrogram_nfft_zero_padding_error = \
    "Window Size is too large. \nNot enough samples in NFFT."

message_non_int_error = ''' must be an integer.'''

message_negative_value = ''' must be larger than zero.'''
#------------------------------------------------------------------
#
# file: DemoErrorMessageDialog
#
class DemoErrorMessageDialog(QtWidgets.QMessageBox):
    """
    Class: DemoErrorMessageDialog
    
    arguments:
     none

    description: 
     This file serves as the QMessageBox that will show when a
     user inputtes a bad value in the preferences window.
    """

    def __init__(self):
        super(DemoErrorMessageDialog, self).__init__(
            icon=QtWidgets.QMessageBox.Warning)
                                                     
        self.setWindowTitle("Error")

    def show_nfft_window_size_error_message(self):
        """
        method: show_nfft_window_size_error_message
        
        arguments:
         none

        returns: 
         none

        description: 
         this message will show when a user inputs a zero padding larger than nfft
        """

        self.setText(message_spectrogram_nfft_zero_padding_error)
        self.show()

    def show_type_error_int(self,
                            variable_name_a):
        """
        method: show_type_error_integer
        
        arguments:
         none

        returns: 
         none

        description: 
         this message will show when a user inputs a value that is not an integer
        """

        self.setText(variable_name_a + message_non_int_error)
        self.show()

    def show_negative_error_value(self,
                                  variable_name_a):
        """
        method: show_negative_error_value
        
        arguments:
         none

        returns: 
         none

        description: 
         this message will show when a user inputs a negative value
        """

        self.setText(variable_name_a + message_negative_value)
        self.show()
