#!/bin/bash

# file: $NEDC_NFC/src/shell/nedc_dpath_resnet_train.sh
#
# revision history:
#
# 20230929 (SM): prep for v2.0.0 release
#
# A simple script that runs the training script of the NEDC Dpath Resnet System

# environment variables
#
. nedc_dpath_resnet_env

# set predetermined argument paths
#
PARAM="$LIB_DIR/nedc_dpath_resnet_train_param.txt"
TRAIN_CSV="$OUTPUT_DIR/log/train/patches.csv"
DEV_CSV="$OUTPUT_DIR/log/dev/patches.csv"

# combine the agument paths to create a single variable that hold all of the
# command line arguments
#
CMD_ARG="-p $PARAM -t $TRAIN_CSV -d $DEV_CSV $MODEL_FILE"

# create variables for the 'nedc_dpath_train.py' script and its directory
#
CMD_DIR="$TOOL_DIR/nedc_dpath_resnet_train"
CMD_FILE="nedc_dpath_resnet_train.py"

# run the 'nedc_dpath_train.py' script from its directory with the proper
# arguments
#
CMD="python $CMD_DIR/$CMD_FILE $CMD_ARG"
$CMD

#
# end of file
