#!/bin/bash

# file: $NEDC_NFC/src/scripts/nedc_dpath_resnet_env.sh
#
# revision history:
#
# 20230929 (SM): prep for v2.0.0 release
#
# A simple script that sets local and environment variables
# for the rest of the software
#

# set an appropriate environment variable for the root node
#
NEDC_NFC=$(realpath $(pwd)/..);
export NEDC_NFC;

# add this tool to the Python library path
#
export PYTHONPATH=$PYTHONPATH:$NEDC_NFC/lib;

# Set up the directory heirarchy of the environment using local
# variables, only available in the current shell
#
ROOT_DIR="$NEDC_NFC"
LIB_DIR="$ROOT_DIR/lib"
CLASS_DIR="$ROOT_DIR/src/python/class"
TOOL_DIR="$ROOT_DIR/src/python/util"
OUTPUT_DIR="$ROOT_DIR/test/output"
LIST_DIR="$ROOT_DIR/test/list"
MODEL_DIR="$ROOT_DIR/models"

# set up list PATHs, using local variables, only available in the current shell
#
TRAIN_LIST="$LIST_DIR/train.list"
DEV_LIST="$LIST_DIR/dev.list"
EVAL_LIST="$LIST_DIR/eval.list"

# set up the model name and PATH, using local variables, only available in the 
# current shell
#
MODEL_FILE="$MODEL_DIR/model.pckl"

# export class and model directory environment variables, available
# across the entire environment, including subprocesses
#
export DPATH_CLASS_DIR="$CLASS_DIR"
export PRETRAINED_MODEL_DIR="$MODEL_DIR/pretrained_models"

#
# end of file
