#!/bin/bash

# file: $NEDC_NFC/src/shell/nedc_dpath_resnet_decode_slide.sh
#
# revision history:
#
# 20230929 (SM): prep for v2.0.0 release
#
# A simple script that runs the slide-decoding script of the NEDC Dpath Resnet System

# environment variables
#
. nedc_dpath_resnet_env

# set predetermined argument paths
#
PARAM="$LIB_DIR/nedc_dpath_resnet_decode_slide_param.txt"
MODEL_FILE="$MODEL_DIR/model.pckl"
CSV_DIR="$OUTPUT_DIR/decode_slide"
MASK_DIR="$OUTPUT_DIR/decode_slide/mask"

# combine the agument paths to create a single variable that hold all of the
# command line arguments
#
CMD_ARG="-p $PARAM -m $MODEL_FILE -c $CSV_DIR -k $MASK_DIR $EVAL_LIST"

# create variables for the 'nedc_dpath_decode_slide.py' script and its directory
#
CMD_DIR="$TOOL_DIR/nedc_dpath_resnet_decode_slide"
CMD_FILE="nedc_dpath_resnet_decode_slide.py"

# run the 'nedc_dpath_decode_slide.py' script from its directory with the proper
# arguments
#
CMD="python $CMD_DIR/$CMD_FILE $CMD_ARG"
$CMD

#
# end of file
