#!/usr/bin/env python
#
# file: $NEDC_NFC/src/main.py
#
# revision history:
#   20260106 (AM): set NEDC_NFC environment variable and adjust python path
#   20250518 (DH): moved style sheet into AppConfig and refactored to
#                  match project commenting standards
#
#
# Entry point for the DPATH Demo. Initializes the Qt application,
# loads the UI style from persistent settings, creates the main window,
# and starts the event loop.
#-------------------------------------------------------------------------------

# import sys module
#
import pathlib as path
import os
import sys

# set NEDC_NFC environment variable and adjust python path
# Set python path to include the 'lib' directory

os.environ["NEDC_NFC"] = \
    os.path.abspath(os.path.join(os.path.dirname( __file__ ), os.pardir))
lib_path = os.path.abspath(os.path.join(os.path.dirname( __file__ ), 
                                        os.pardir, 'lib'))
sys.path.insert(0, lib_path)

# import Qt application and main window
#
from PyQt6.QtWidgets import QApplication
from nedc_dpath_demo_core import MainWindow

# import application configuration singleton
#
from nedc_dpath_demo_config import DEF_STYLE_SHEET

#-------------------------------------------------------------------------------
#
# Functions are listed here
#
#-------------------------------------------------------------------------------


def run():
    """
    method: run

    arguments:
      none

    return:
      int: exit status code from the Qt event loop

    description:
      Create the QApplication, apply a persisted style sheet if any,
      instantiate and show the MainWindow, then start the event loop.
    """
    # create the Qt application object
    #
    app = QApplication(sys.argv)

    # retrieve style sheet from settings and apply if present
    #
    app.setStyleSheet(DEF_STYLE_SHEET)

    # instantiate the primary window and display it
    #
    window = MainWindow()
    window.show()

    # execute the Qt event loop and return its exit value
    #
    return sys.exit(app.exec())

#  
# end of method

# begin gracefully when run as a script
#
if __name__ == "__main__":
    sys.exit(run())

#
# end of file
