#!/usr/bin/env python
#
# file: $NEDC_NFC/util/python/nedc_imld/v5.0.1/app/extensions/scheduler.py
#
# revision history:
#
# 20250925 (SA): refactored code to fit ISIP standards
#
# This module encapsulates scheduling functions in the IMLD app.
#-------------------------------------------------------------------------------

# import system modules
#
from .blueprint import clean_cache
from flask_apscheduler import APScheduler
import os

# import nedc modules
#
import nedc_debug_tools as ndt

# force use of zoneinfo instead of pytz
#
os.environ['PYTZ_USE_NOTZ'] = '1'  

#-------------------------------------------------------------------------------
#
# global variables are listed here
#
#-------------------------------------------------------------------------------

# set the filename using basename
#
__FILE__ = os.path.basename(__file__)

# constant for scheduler job ID to clean cache
#
SCHEDULER_JOB_ID_CLEAN_CACHE = 'clean_cache'
SCHEDULER_JOB_TRIGGER_CLEAN_CACHE = 'interval'

# interval (in seconds) to clean the cache
#
CACHE_CLEAN_INTERVAL = 300

# declare a global debug object so we can use it in functions
#
dbgl = ndt.Dbgl()

# create APS Schedule instance
#
scheduler = APScheduler()

#-------------------------------------------------------------------------------
#
# functions are listed here
#
#-------------------------------------------------------------------------------

def main(argv):

    # validate Flask app instance
    #
    if app is None:
        print("Error: %s (line: %s) %s: app instance is None (%s)" %
              (__FILE__, ndt.__LINE__, ndt.__NAME__, fname))
        sys.exit(os.EX_SOFTWARE)
    
    # add a scheduled job to clean the cache every 5 minutes
    #
    scheduler.add_job(id=SCHEDULER_JOB_ID_CLEAN_CACHE, func=clean_cache, 
                     trigger=SCHEDULER_JOB_TRIGGER_CLEAN_CACHE, seconds=CACHE_CLEAN_INTERVAL)

    # confirm job creation
    #
    jobs = scheduler.get_jobs()
    if jobs is None:
        print("Error: %s (line: %s) %s: failed to create scheduled job (%s)" %
              (__FILE__, ndt.__LINE__, ndt.__NAME__))
        sys.exit(os.EX_SOFTWARE)
    
    # exit gracefully
    #
    return True

# begin gracefully
#
if __name__ == '__main__':
    main(sys.argv[0:])

#
# end of file