#!/usr/bin/env python
#
# file: $NEDC_NFC/util/python/nedc_imld/v5.0.1/app/__init__.py
#
# revision history:
#
# 20250925 (SA): refactored code to fit ISIP standards
#
# This class defines the configuration settings for IMLD.
#-------------------------------------------------------------------------------

# import system modules
#
import os
from os.path import abspath
import sys

# import nedc modules
#
import nedc_debug_tools as ndt

# import application components and extensions
#
from .extensions.base import app
from .extensions.blueprint import main
from .extensions.scheduler import scheduler

#-------------------------------------------------------------------------------
#
# global variables are listed here
#
#-------------------------------------------------------------------------------

# set the filename using basename
#
__FILE__ = os.path.basename(__file__)

# set default port for IMLD app
#
DEFAULT_PORT = 5000

# declare a global debug object so we can use it in functions
#
dbgl = ndt.Dbgl()

# root path of current file
#
root_path = abspath(__file__)

# truth value: status returned from registering blueprint
#
register_status = app.register_blueprint(main)

#-------------------------------------------------------------------------------
#
# classes are listed here
#
#-------------------------------------------------------------------------------

class IMLD():
    """
    class: IMLD

    description:
     This class defines configuration settings for the IMLD Flask app,
     including paths for static files, templates, logging, and backend
     components.
    """

    def __init__(self):
        """
        method: constructor

        arguments: None

        return: None

        description:
         Initializes file paths and application settings based on the
         provided root. Registers the blueprint and initializes the
         scheduler.
        """

        # check for successful import of components
        #
        if app is None:
            print("Error: %s (line: %s) %s: app object is None" %
                (__FILE__, ndt.__LINE__, ndt.__NAME__))
            sys.exit(os.EX_SOFTWARE)
            
        if main is None:
            print("Error: %s (line: %s) %s: main object is None" %
                  (__FILE__, ndt.__LINE__, ndt.__NAME__))
            sys.exit(os.EX_SOFTWARE)
        
        # add root path to app
        #
        app.set_root(root_path)    

        # check if blueprint was registered successfully
        #
        if register_status is False:
            print("Error: %s (line: %s) %s: failed to register blueprint" %
                (__FILE__, ndt.__LINE__, ndt.__NAME__))
            sys.exit(os.EX_SOFTWARE)

        # initialize and start scheduler
        #
        if scheduler is None:
            print("Error: %s (line: %s) %s: scheduler object is None" %
                (__FILE__, ndt.__LINE__, ndt.__NAME__))
            sys.exit(os.EX_SOFTWARE)
            
        scheduler.init_app(app)
        scheduler.start()
        
    #
    # end of method
    
    def run(self):
        """
        method: run

        arguments: None

        return: None

        description:
         Starts the Flask application with debugging enabled.
        """

        # read the IMLD_PORT env variable at runtime
        # if it isn't defined, fall back to default port
        #
        port = int(os.getenv('IMLD_PORT', DEFAULT_PORT))

        # starts Flask application with debugging enabled
        #
        app.run(port=port, debug=False, use_reloader=False)
    #
    # end of method
#
# end of class

#
# end of file
