%%%%%%%%%%%%%%%%%%%%%%IEEE SPMB ABSTRACT CLASS%%%%%%%%%%%%%%%%%%%%%%%%%%%
% version 1.0
% This is the class file for IEEE SPMB Abstracts. 
% Copyright ISIP Temple University
% Ammar Ahmed - May 8, 2020

\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{spmbabs}[2022/01/01 IEEE SPMB Abstract LaTeX class]

\LoadClass[11pt,onecolumn]{article}
\setlength{\parindent}{0pt}
\setlength{\parskip}{12pt}

%%%%%%%%%%%%%%%%%%%IEEE SPMB FONT Settings%%%%%%%%%%%%%%%%%%%%%%%%%%
% Import the Times New Roman type font. Do not use Times package as it is outdated.
\RequirePackage{mathptmx}
% \RequirePackage{mathptmx}
% \RequirePackage{newtxtext,newtxmath}

% As the above font is not exactly Time New Roman, set the line spread to 1.0 to make the overall font more like a Times New Roman (usually a linespread of 0.965 makes the best output)
\linespread{0.965}
%---------------------------------------------------

%%%%%%%%%%%%%%%%%%%%%paper margin settings%%%%%%%%%%%%%%%%%%%%%%%%%
% Import geometry package to set the page type and page margins
\RequirePackage{geometry}
\geometry{letterpaper, portrait, margin=1in}

%---------------------------------------------------

%%%%%%%%%%%%%%%%% ITEMIZATION and ENUMERATION SETTINGS%%%%%%%%%%%%%%%
% Import enumitem package to set the spacing for itemization and enumeration
\RequirePackage{enumitem}
\setlist[itemize]{topsep=-6pt,itemsep=6pt, parsep = 0pt} % adjust spacings
\setlist[enumerate]{topsep=-6pt,itemsep=6pt,parsep = 0pt} % adjust spacings
% change the itemization font size
\let\olditemize\itemize
\let\endolditemize\enditemize
\renewenvironment{itemize}{%
    \small
    \olditemize
}{%
    \endolditemize
}
% change the enumeration font size
\let\oldenumerate\enumerate
\let\endoldenumerate\endenumerate
\renewenvironment{enumerate}{%
    \small
    \oldenumerate
}{%
    \endoldenumerate
}
%---------------------------------------------------

%%%%%%%%%%%%%%%%%%%Title and Affiliation settings%%%%%%%%%%%%%%%%%%%%%%%
\newcommand{\affiliations}[1]{\def\@affiliations{#1}}
\newcommand{\affilend}{\\*\vspace{0.2em}} %% use it to separate affiliations

% Make the title (title with authors)
\renewcommand{\maketitle}{%
    \begin{center}
        {\fontsize{11}{0}\selectfont\textbf{\vspace{0.32em}\@title}\par\vspace{-0.2em}}
        {\fontsize{11}{0}\selectfont\textit{\@author\vspace{0.1em}}\par\vspace{0.0em}} 
        {\fontsize{11}{0}\selectfont\@affiliations\par}
    \end{center}
    \vspace{-11.8pt}
}
%---------------------------------------------------


%%%%%%%%%%%%%%%%%%%%%%Header and Footer settings%%%%%%%%%%%%%%%%%%%
% control headers and footers
\RequirePackage{fancyhdr}
\pagestyle{fancy}
\fancyhf{}
\renewcommand{\headrulewidth}{0pt}
\setlength{\headheight}{13.6pt}
%---------------------------------------------------

%%%%%%%%%%%%%%%%%%%%%%SECTION AND SUBSECTION SETTINGS%%%%%%%%%%%%%%%%%%%%%%%
%\def\acknowledgements{{\sc Acknowledgements} \par}
%\def\references{\fontsize{11}{0} \selectfont{\sc References}}
%\renewcommand\refname{\references}
%---------------------------------------------------

%%%%%%%%%%%%%%%%%%%%%%%%Equation Settings%%%%%%%%%%%%%%%%%%%%%%

%% change spacing before and after equations
\makeatletter
\g@addto@macro\normalsize{%
  \setlength\abovedisplayskip{6pt}
  \setlength\belowdisplayskip{6pt}
  \setlength\abovedisplayshortskip{6pt}
  \setlength\belowdisplayshortskip{6pt}
}
\makeatother
%%---------------------------------------------------

%%% Other Settings %%%
% Import url package to make the url font compatible with existing SPMB template
\RequirePackage{url}
\def\UrlFont{\itshape}